function PrintMatrix(x,RowNames,ColNames,ColFmt)
%	PRINTMATRIX - PrintMatrix(x, RowNames, ColNames, ColFmt)

[n,m]=size(x);

if nargin==1 | isnumeric(RowNames)
   RowNames = cell(n,1);
   for i=1:n
      RowNames{i}=int2str(i);
   end
elseif ischar(RowNames)
   a = RowNames;
   RowNames = cell(n,1);
   for i=1:n
      RowNames{i}=a;
   end
else
   if length(RowNames)~=n
      disp('PrintMatrix error.  RowNames.');
      disp(RowNames);
   end
end

if nargin==2 | isnumeric(ColNames)
   ColNames = cell(1,m);
   for i=1:m
      ColNames{i}=int2str(i);
   end
elseif ischar(ColNames)
   a = ColNames;
   ColNames = cell(m,1);
   for i=1:m
      ColNames{i}=a;
   end
else
   if length(ColNames)~=m
      disp('PrintMatrix error.  ColNames.');
      disp(ColNames);
   end
end

if nargin==3 | isnumeric(ColFmt)
   ColFmt = cell(1,m);
   for i=1:m
      ColFmt{i} = '%11g';
   end
elseif ischar(ColFmt)
   a = ColFmt;
   ColFmt = cell(1,m);
   for i=1:m
      ColFmt{i} = a;
   end
elseif iscell(ColFmt)
   l = length(ColFmt);
   if l<m
      for i=(l+1):m
         ColFmt{i} = ColFmt{l};
      end
   end
end

P = char(' ', char(RowNames));
for i=1:m
   c = num2str(x(:,i),ColFmt{i});
   [nc, mc] = size(c);
   ColHead = ColNames{i};
   w = length(ColHead);
   if w<mc
      ColHead = [blanks(mc-w) ColHead];
      Col = [ColHead;c];
   elseif w>mc
      c = [repmat(' ',nc,w-mc) c];
      Col = [ColHead;c];
   else
      Col = [ColHead;c];
   end
   if any(Col(:,1)~=' ')
      Col = [repmat(' ',nc+1,1) Col];
   end
   P = [P Col];
end

disp(P);


